### DRAW FIGURES 1, 2, and 3 FROM 'THE WELL-MEANING ECONOMIST'
### NEW USERS NEED TO CHANGE ENTRY IN LINE 5 ONLY

# Set file location for saving the charts
setwd("G:/Research/GorajekA - GENERAL/RDP The Well-meaning Economist/Replication Files") # Files will be saved to this folder

### NO NEED TO EDIT ANYTHING BEYOND THIS POINT #######################################################################################



### FIGURE 1

# Clear environment, set output name, and set output dimensions
rm(list=ls()) # Clears environment
pdf("Figure 1.pdf", width=9, height = 7.5)
par(xpd = NA) # Clips everything to the plot space
par(mfrow = c(2, 2)) # Sets the grid layout, subsequent figures will be drawn by row
par(mar = c(3.5, 4.5, 2, 1.5)) # Sets the margins between panels
par(oma = c(0, 0, 0, 0)) # Sets the outer margins

# Create data to use for plots
X <- seq(0.01,10,.01)
LogX <- log(X)
X2 <- X^2
X2[948:1000] <- NA
Xneg1 <- 1/X
Xneg1[1:49] <- NA

# Draw arithmetic mean panel
plot(X, X, col="blue", axes = "False", xlab="", xlim = c(0,10), xaxs="i", ylab="", ylim = c(0,10),
     yaxs="i", type="l", lwd=2, cex=2, cex.axis=1)
box(col = "black")
title(main="Arithmetic Mean", line=0.5, cex.main=1.5)
text(5,7.5,expression(f(y)== paste(alpha,"+", beta,"y")), cex=1.5)
axis(1,at=c(1,(1+9)/2,9),labels=c(expression('y'[1]),expression(f^{-1}*"(E[f(Y)])"),expression('y'[2])),
     cex.axis=1.5)
axis(2,at=c(1,(1+9)/2,9),labels=c(expression("f("*'y'[1]*")"),"E[f(Y)]",expression("f("*'y'[2]*")")),
     las=1,  cex.axis=1.5)
arrows(1, 0,  1,  0.5,  length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(1, 0.5,  1,  1, col = "grey", lty = 1, lwd = 1)
arrows(1, 1,  0.5,  1, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(0.5, 1,  0,  1, col = "grey", lty = 1, lwd = 1)
arrows(9, 0,  9,  5, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(9, 5,  9,  9, col = "grey", lty = 1, lwd = 1)
arrows(9, 9,  5,  9, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(5, 9, 0, 9, col = "grey", lty = 1, lwd = 1)
arrows(5/2-.01, 5, 5/2, 5, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(0, 5,  5, 5, col = "black", lty = 2, lwd = 1)
arrows(5, 5/2+.01, 5, 5/2, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(5, 5,  5, 0, col = "black", lty = 2, lwd = 1)

# Draw geometric mean panel
plot(X, LogX, col="blue", axes = "False", xlab="", xlim = c(0,10), xaxs="i", ylab="", ylim = c(-5,5),
     yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
title(main="Geometric Mean", line=0.5, cex.main=1.5)
text(6,0.5,expression(f(y)== paste(alpha,"+", beta,"ln(y)")), cex=1.5)
axis(1,at=c(1,3,9),labels=c(expression('y'[1]),expression(f^{-1}*"(E[f(Y)])"),expression('y'[2])),
     cex.axis=1.5)
axis(2,at=c(log(1),log(3),log(9)),labels=c(expression("f("*'y'[1]*")"),"E[f(Y)]",expression("f("*'y'[2]*")")),
     las=1, cex.axis=1.5)
arrows(1, -5,  1,  (log(1)-5)/2, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(1, (log(1)-5)/2,  1,  log(1), col = "grey", lty = 1, lwd = 1)
arrows(1, log(1),  0.5,  log(1), length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(0.5, log(1),  0,  log(1), col = "grey", lty = 1, lwd = 1)
arrows(9, -5,  9,  (log(9)-5)/2, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(9, (log(9)-5)/2,  9,  log(9), col = "grey", lty = 1, lwd = 1)
arrows(9, log(9),  9/2,  log(9), length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(9/2, log(9), 0, log(9), col = "grey", lty = 1, lwd = 1)
arrows(exp((log(9)+log(1))/2)/2-.01, (log(9)+log(1))/2, exp((log(9)+log(1))/2)/2, (log(9)+log(1))/2,
       length = 0.075, col = "black", lty = 1, lwd = 1)
segments(0, (log(9)+log(1))/2,  exp((log(9)+log(1))/2),  (log(9)+log(1))/2, 
         col = "black", lty = 2, lwd = 1)
arrows(exp((log(9)+log(1))/2), (log(9)-5)/2+.01, exp((log(9)+log(1))/2), (log(9)-5)/2, length = 0.075,
       col = "black", lty = 1, lwd = 1)
segments(exp((log(9)+log(1))/2), (log(9)+log(1))/2,  exp((log(9)+log(1))/2), -5, col = "black", lty = 2,
         lwd = 1)

# Draw quadratic mean panel
plot(X, X2, col="blue", axes = "False", xlab="", xlim = c(0,10), xaxs="i", ylab="", ylim = c(0,90),
     yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
title(main= "Quadratic Mean", line=0.5, cex.main=1.5)
text(2.25,20,expression(f(y)== paste(alpha,"+", beta,"y"^{2})), cex=1.5)
axis(1,at=c(1,sqrt((1^2+9^2)/2),9),labels=c(expression('y'[1]),expression(f^{-1}*"(E[f(Y)])"),expression('y'[2])),
     cex.axis=1.5)
axis(2,at=c(1,(1^2+9^2)/2,9^2),labels=c(expression("f("*'y'[1]*")"),"E[f(Y)]",expression("f("*'y'[2]*")")),
     las=1,  cex.axis=1.5)
segments(1, 0,  1,  1, col = "grey", lty = 1, lwd = 1)
segments(1, 1,  0,  1, col = "grey", lty = 1, lwd = 1)
arrows(9, 0,  9,  (9^2)/2, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(9, (9^2)/2,  9,  9^2, col = "grey", lty = 1, lwd = 1)
arrows(9, 9^2,  4.5,  9^2, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(4.5, 9^2, 0, 9^2, col = "grey", lty = 1, lwd = 1)
arrows(sqrt((1^2+9^2)/2)/2-.01, (1^2+9^2)/2, sqrt((1^2+9^2)/2)/2, (1^2+9^2)/2, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(0, (1^2+9^2)/2,  sqrt((1^2+9^2)/2), (1^2+9^2)/2, col = "black", lty = 2, lwd = 1)
arrows(sqrt((1^2+9^2)/2), (1^2+9^2)/2/2+0.5,  sqrt((1^2+9^2)/2), (1^2+9^2)/2/2, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(sqrt((1^2+9^2)/2), (1^2+9^2)/2,  sqrt((1^2+9^2)/2), 0, col = "black", lty = 2, lwd = 1)

# Draw harmonic mean panel
plot(X, Xneg1, col="blue", axes = "False", xlab="", xlim = c(0,10), xaxs="i", ylab="", ylim = c(0,2),
     yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
title(main= "Harmonic Mean", line=0.5, cex.main=1.5)
text(3,1.5,expression(f(y)== paste(alpha,"+", beta,"y"^{-1})), cex=1.5)
axis(1,at=c(1,1/(((1+1/9)/2)),9),labels=c(expression('y'[1]),expression(paste(phantom(spaaace),f^{-1},"(E[f(Y)])")),expression('y'[2])),
     cex.axis=1.5)
axis(2,at=c(1,(1+1/9)/2,1/9),labels=c(expression("f("*'y'[1]*")"),"E[f(Y)]",expression("f("*'y'[2]*")")),
     las=1,  cex.axis=1.5)
arrows(1, 0,  1,  0.5,  length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(1, 0,  1,  1, col = "grey", lty = 1, lwd = 1)
arrows(1, 1,  0.5,  1, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(1, 1,  0,  1, col = "grey", lty = 1, lwd = 1)
arrows(9, 0,  9,  (1/9)/2, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(9, (1/9)/2,  9,  1/9, col = "grey", lty = 1, lwd = 1)
arrows(9, 1/9,  4.5,  1/9, length = 0.075, col = "grey", lty = 1, lwd = 1)
segments(4.5, 1/9, 0, 1/9, col = "grey", lty = 1, lwd = 1)
arrows(1/(((1+1/9)/2))/2-.01, (1+1/9)/2, 1/(((1+1/9)/2))/2, (1+1/9)/2, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(0, (1+1/9)/2,  1/(((1+1/9)/2)), (1+1/9)/2, col = "black", lty = 2, lwd = 1)
arrows(1/(((1+1/9)/2)), (1+1/9)/2/2+0.01,  1/(((1+1/9)/2)), (1+1/9)/2/2, length = 0.075, col = "black", lty = 1, lwd = 1)
segments(1/(((1+1/9)/2)), (1+1/9)/2,  1/(((1+1/9)/2)), 0, col = "black", lty = 2, lwd = 1)

dev.off() # Turns off the deviation to PDF 



### FIGURE 2

# Clear environment, set output name, and set output dimensions
rm(list=ls()) # Clears environment
pdf("Figure 2.pdf", width=7, height = 5) # Files will be saved with this name
par(mfrow = c(1, 1)) # Sets the grid layout, subsequent figures will be drawn by row
par(xpd = NA) # clip everything to the plot space
par(mar = c(0, 3, 0, 3)) # sets the margins between panels
par(oma = c(0, 0, 0, 0)) # sets the outer margins

# Generate the plot labels and an empty density matrix to populate
indep <- seq(0,1,0.01) # This contains the labels for the columns of the density matrix
index <- seq(0,100,1) # This contains the matrix position correpsonding to each entry for the independent variable
trade <- seq(0,4,0.01) # This contains the labels for the rows of the density matrix #
densities <- matrix(0L, nrow = length(trade), ncol = length(indep))
z <- 0 # This controls how you set the dummy variable in the Santos Silva DGP

# Populate the density matrix and transpose
for (condition in index) {
  cmean <- exp(condition/100 + z) #
  cvar <- exp(condition/100 + z) #
  mu <- log(cmean/(sqrt(1+cvar/(cmean^2))))
  sd <- sqrt(log(1+cvar/(cmean^2)))  
  densities[,condition+1] <- dlnorm(trade,mu,sd)
}
densitiest = t(densities)

# Generate data for densities overlay. This will serve as lines indicating the two mean types
densities2 <- densities
tradeindex <- seq(0,400,1) #
spacedindex <- seq(0,100,5)
for (condition in index) {
  arithmean <- exp(condition/100+z) #
  cvar <- exp(condition/100+z) #
  geomean <- arithmean/(sqrt(1+cvar/(arithmean^2)))
  rowarithmean <- arithmean*100+1
  rowgeomean <- geomean*100+1
  for (level in tradeindex){
    if ((abs(level-rowarithmean)>4)&(abs(level-rowgeomean)>4)) {
      densities2[level,condition] <- NA 
    }
  }
}
for (condition in spacedindex) {
  arithmean <- exp(condition/100+z) #
  cvar <- exp(condition/100+z) #
  geomean <- arithmean/(sqrt(1+cvar/(arithmean^2)))
  rowarithmean <- arithmean*100+1
  rowgeomean <- geomean*100+1
  for (level in tradeindex){
    if (abs(level-rowarithmean)>4) {
      densities2[level,condition] <- NA 
    }
  }
}
densities2t <- t(densities2) 

# Set matrix of colours to pass to persp() (https://stat.ethz.ch/pipermail/r-help/2003-September/039104.html)
surf_colours <- function(x, col = topo.colors(20)) {

# Drop the 'borders' and average the facet corners
# We need (nx - 1) x (ny - 1) facet colours
  nr <- dim(x)[1L]
  nc <- dim(x)[2L]
  xavg <- (x[-1L, -1L] + x[-1L, -(nc - 1L)] + 
           x[-(nr - 1L), -1L] + x[-(nr - 1L), -(nc - 1)]) / 4.0

# Construct the actual colours matrix
  mcolors <- col[cut(xavg, breaks = length(col), include.lowest = TRUE)]
  return (mcolors)
}

# Set the colour palette
col_palete <- colorRampPalette(c("blue", "purple", "red", "orange", "yellow"))

# Plot the base perspective chart
persp(x=indep, y=trade, densitiest, xlab = "x", ylab = "Trade", zlab = "Cond. density", zlim = c(0,1),
      theta = 305, phi = 25, r = sqrt(3), d = 1, scale = TRUE, expand = 0.3,
      col = surf_colours(x = densitiest, col = col_palete(80)),
      border = NA, ltheta = 90, lphi = 40, shade = 0.2, nticks = 3, ticktype = "detailed") #

# Overlay the lines
par(new=TRUE)
persp(x=indep, y=trade, densities2t, zlim = c(0,1), 
      theta = 305, phi = 25, r = sqrt(3), d = 1, scale = TRUE, expand = 0.3,
      col = "black", border = NA, ltheta = 90, lphi = 40, shade = 0.2, box = F) #

# Drop a legend underneath the chart
par(oma= c(0,0,0,0), mar=c(0,0,0,0), new = TRUE)
plot(0, 0, type = "n", bty = "n", xaxt = "n", yaxt = "n")
legend("bottom", c("Cond. arithmetic mean", "Cond. geometric mean"), xpd = TRUE, horiz = TRUE, inset = c(0, 
  0), bty = "n", lty = c(1, 2), col = "black", lwd = 3, cex = 1)

dev.off() # Turns off the deviation to PDF



### FIGURE 3

# Clear environment, set output name, and set output dimensions
rm(list=ls()) # Clears environment
pdf("Figure 3.pdf", width=7, height = 9) 
par(xpd = FALSE) # Clips everything to the plot space
par(mfrow = c(4, 3)) # Sets the grid layout, subsequent figures will be drawn by row
par(mar = c(0, 0, 0, 0)) # Sets the margins between panels
par(oma = c(10, 4.2, 0.3, 4.2)) # Sets the outer margins

# Create data to use for plots (choosing arbitrary lambda for presentational convenience)
Y <- seq(-2000000000,6000000000,10000000)
CostA1 <- 0.000000001*(Y-2000000000)^2
CostA2 <- CostA1
CostA2[1:200] <- NA 
CostG <- (2000)^3*(log(Y)-log(2000000000))^2
CostQ <- (0.0000000006)^3*(Y^2-2000000000^2)^2
CostQ[1:200] <- NA
CostH1 <- (3000000000)^3*(Y^(-1)-2000000000^(-1))^2
CostH2 <- CostH1
CostH2[1:200] <- NA
CostR1 <- 10*(Y^(0.5)-2000000000^(0.5))^2
CostR1[1:200] <- NA
CostB <- (2000)^3*(log(Y+1)-log(2000000000+1))^2
CostI1 <- (2000)^3*(log(Y + sqrt(Y^2 + 1)) - log(2000000000 + sqrt(2000000000^2 + 1)))^2
CostI2 <- CostI1
CostI2[1:200] <- NA
CostM1 <- 10000000000*((Y-2000000000))^0
CostM1[401] <- 0
CostM2 <- CostM1
CostM2[1:200] <- NA
CostMed1 <- 5*Mod(Y-2000000000)
CostMed2 <- CostMed1
CostMed2[1:200] <- NA
NegDummy <- ifelse(Y <= 2000000000, 1, 0)
Cost25P1 <- 10*(Y-2000000000)*(0.25-NegDummy)
Cost25P2 <- Cost25P1
Cost25P2[1:200] <- NA
Cost75P1 <- 10*(Y-2000000000)*(0.75-NegDummy)
Cost75P2 <- Cost75P1
Cost75P2[1:200] <- NA
CostC1 <- (0.0000000175)^6*(Y^3-2000000000^3)^2
CostC2 <- CostC1
CostC2[1:200] <- NA

# Panel 1
# Plot Square Root Mean
plot(Y, CostR1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Square Root Mean", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) ="*Y^{1/2}), side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.5)
segments(0, 0, 0, 20000000000, col = "gray", lty = 2, lwd = 0.5)

# Panel 2
# Plot Arithmetic Mean
plot(Y, CostA2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Arithmetic Mean", side = 3, line = -2, cex=1.2)
mtext("f(Y) = Y", side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.5)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostA1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 3
# Plot Quadratic Mean
plot(Y, CostQ, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Quadratic Mean", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) ="*Y^{2}), side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.5)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)

# Panel 4
# Plot Harmonic Mean
plot(Y, CostH2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Harmonic Mean", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) ="*Y^{-1}), side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.5)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostH1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 5
# Plot Mode
plot(Y, CostM2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Mode", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) = N/A"), side = 3, line = -4, cex=1.2)
#title(ylab="Cost", line=0.5, cex.lab=1.2)
#title(xlab="Trade", line=2.5, cex.lab=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostM1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 6
# Plot Cubic Mean
plot(Y, CostC2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Cubic Mean", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) ="*Y^{3}), side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.5)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostC1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 7
# Plot 25th Percentile
plot(Y, Cost25P2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("25th Percentile", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) = N/A"), side = 3, line = -4, cex=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, Cost25P1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 8
# Plot Median
plot(Y, CostMed2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Median", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) = N/A"), side = 3, line = -4, cex=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostMed1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)


# Panel 9
# Plot 75th Percentile
plot(Y, Cost75P2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("75th Percentile", side = 3, line = -2, cex=1.2)
mtext(expression("f(Y) = N/A"), side = 3, line = -4, cex=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, Cost75P1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

# Panel 10
# Plot Geometric Mean
plot(Y, CostG, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("Geometric Mean", side = 3, line = -2, cex=1.2)
mtext("f(Y) = ln(Y)", side = 3, line = -4, cex=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
axis(1,at=c(-2000000000,0,2000000000,4000000000,6000000000),labels=c(-2,0,"*2*",4,6), cex.axis=1.75)

# Panel 11
# Plot gsl mean
plot(Y, CostB, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("GSL Mean", side = 3, line = -2, cex=1.2)
mtext("f(Y) = ln(Y+US$1)", side = 3, line = -4, cex=1.2)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
axis(1,at=c(0,2000000000,4000000000,6000000000),labels=c(0,"*2*",4,6), cex.axis=1.75)

# Panel 12
# Plot IHS Mean
plot(Y, CostI1, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2)
box(col = "black")
mtext("IHS Mean", side = 3, line = -2, cex=1.2)
mtext("f(Y) = IHS(Y)", side = 3, line = -4, cex=1.2)
title(ylab="Cost", line=0.5, cex.lab=1.2)
axis(1,at=c(0,2000000000,4000000000,6000000000),labels=c(0,"*2*",4,6), cex.axis=1.75)
segments(0, 0, 0, 20000000000, col = "grey", lty = 2, lwd = 0.5)
par(new=TRUE)
plot(Y, CostI2, col="blue", axes = "False", xlab="", xlim = c(-2000000000,6000000000), xaxs="i", ylab="", 
     ylim = c(0,20000000000), yaxs="i", type="l", lwd=2, cex=2, lty=2)

mtext("Observed level of trade, US$billions", side = 1, line = 3, outer = TRUE, cex = 1.2)
mtext("Cost (arbitrary linear scale)", side = 2, line = 1.5, outer = TRUE, cex = 1.2)
mtext("Cost (arbitrary linear scale)", side = 4, line = 1.5, outer = TRUE, cex = 1.2)

# Drop a legend underneath the chart
par(fig = c(0, 1, 0, 1), oma = c(0, 0, 0, 0), mar = c(0, 0, 0, 0), new = TRUE)
plot(0, 0, type = "n", bty = "n", xaxt = "n", yaxt = "n")
legend("bottom", c("Plausible region of trade", "Implausible region of trade"), xpd = TRUE, horiz = TRUE, inset = c(0, 
      0), lty = c(1, 2), lwd = 3, col = "blue", cex = 1.75, box.lty = 0)

dev.off() # Turns off the deviation to PDF 